	% Example 9.11   LP-> BS Cauer
	clear all
	fs = 16; 		% Font size
	lw = 2; 		% Linewidth
	fn = 'times'; 	% Font
	% Requirements for the digital bandstop filter
	wc1T = 0.4*pi;					wc2T = 0.7*pi;
	ws1T = 0.5*pi;					ws2T = 0.6*pi;
	Amax = -10*log10(1-0.5^2);		Amin = 70;
	
	% Requirements for the analog prototype lowpass filter
	T = 1;
	Wac1 = (2/T)*tan(wc1T/2);	Wac2 = (2/T)*tan(wc2T/2);
	Was1 = (2/T)*tan(ws1T/2);	Was2 = (2/T)*tan(ws2T/2);
	Wac1*Wac2;
	Was1*Was2;	
	% We select
	Was1 = Wac1*Wac2/Was2;
	
	% Band edges for the analog lowpass filter
	Omegac = (T/2)*Wac1*Wac2/(Wac2 - Wac1);
	Omegas = (T/2)*Wac1*Wac2/(Was2 - Was1);
	
	% Design of the analog prototype lowpass filter (Cauer)
	N = CA_ORDER_S(Omegac, Omegas, Amax, Amin)
	N = 4;	% We must select an integer order
	
	[Ga, Za, R_ZEROS, Pa, Wsnew] = CA_POLES_S(Omegac, Omegas, Amax, Amin, N);
	
	% Transformation the analog filter into a digital lowpass filter
	[G, Z, P] = PZ_2_PZ_Z(Ga, Za, Pa, Omegac*T);
	
	figure(1)
	wT = linspace(0, pi, 1000);	
	Att = PZ_2_ATT_Z(G, Z, P, wT);
	Taug = PZ_2_TG_Z(G, Z, P, wT);
	axis_Amax = 80;	axis_Tg_max = 40;
	PLOT_ATT_TG_Z(Att, Taug, wT, axis_Amax, axis_Tg_max)	
		fs = 16; % Font size
	lw = 1; % Linewidth
	fn = 'times'; % Font
	text(0.5, 11.5,'{\it\tau_g}({\ite^j^\omega^T })','FontName',fn,'FontSize',fs);	
	text(1.8, 15,'{\itA}({\ite^j^\omega^T})','FontName',fn,'FontSize',fs);
	
	
	% Transformation the digital lowpass filter into a digital bandstop filter
	[Gbs, Zbs, Pbs] = PZ_2_BS_Z(G, Z, P, wc1T, wc2T, Omegac*T);
	
	figure(2)
	wT = linspace(0, pi, 1000);
	axis_Amax = 80;	 axis_Tg_max = 40;
	Att = PZ_2_ATT_Z(Gbs, Zbs, Pbs, wT);
	Taug = PZ_2_TG_Z(Gbs, Zbs, Pbs, wT);
	PLOT_ATT_TG_Z(Att, Taug, wT, axis_Amax, axis_Tg_max)	
		fs = 16; % Font size
	lw = 1; % Linewidth
	fn = 'times'; % Font
	text(0.5, 11.5,'{\it\tau_g}({\ite^j^\omega^T })','FontName',fn,'FontSize',fs);	
	text(1.6, 20,'{\itA}({\ite^j^\omega^T})','FontName',fn,'FontSize',fs);
	
	
	figure(3)
	PLOT_PZ_Z(Zbs, Pbs)
	
	
